//page d'accueil
        document.addEventListener('DOMContentLoaded', function() {
            const slider = document.getElementById('slider-art');
            const steps = document.querySelectorAll('.step');
            const yearIndicator = document.getElementById('current-year');
            const years = ['2025', '2050', '2070', '2100'];
            const colors = ['#ffa500', '#ff6b35', '#ff4500', 'red'];
            const backgrounds = [
                'radial-gradient(circle at center, #1a0000 0%, #0f0f0f 100%)',
                'radial-gradient(circle at center, #331100 0%, #1a0800 100%)',
                'radial-gradient(circle at center, #4d0000 0%, #260000 100%)',
                'radial-gradient(circle at center, #330000 0%, #0a0000 100%)'
            ];

            // Fonction pour mettre à jour l'interface
            function updateInterface(value) {
                const val = parseInt(value);
                
                // 1. Mettre à jour les images
                document.querySelectorAll('.layer-image').forEach(el => el.classList.remove('active'));
                const imgTarget = document.getElementById('img-' + val);
                if(imgTarget) {
                    imgTarget.classList.add('active');
                    imgTarget.style.animation = 'none';
                    setTimeout(() => {
                        imgTarget.style.animation = 'fireGlow 3s ease-in-out infinite alternate';
                    }, 10);
                }

                // 2. Mettre à jour les étapes de la timeline
                steps.forEach(step => {
                    step.classList.remove('active');
                    if(parseInt(step.dataset.step) === val) {
                        step.classList.add('active');
                        step.classList.add('pulse');
                    } else {
                        step.classList.remove('pulse');
                    }
                });

                // 3. Mettre à jour l'indicateur d'année
                yearIndicator.textContent = years[val];
                yearIndicator.style.color = colors[val];
                document.querySelector('.year-indicator').style.borderLeftColor = colors[val];

                // 4. Mettre à jour le texte
                document.querySelectorAll('.story-block').forEach(el => el.classList.remove('active'));
                const txtTarget = document.getElementById('txt-' + val);
                if(txtTarget) txtTarget.classList.add('active');

                // 5. Mettre à jour le fond
                const visu = document.querySelector('.art-visu');
                if(visu) {
                    visu.style.background = backgrounds[val];
                    visu.style.transition = "background 1.2s cubic-bezier(0.4, 0, 0.2, 1)";
                }

                // 6. Mettre à jour le slider visuellement
                const gradient = `linear-gradient(to right, ${colors.slice(0, val+1).join(', ')})`;
                slider.style.background = gradient;
            }

            // Événements pour le slider
            slider.addEventListener('input', function() {
                updateInterface(this.value);
            });

            // Événements pour les étapes de la timeline
            steps.forEach(step => {
                step.addEventListener('click', function() {
                    const stepValue = this.dataset.step;
                    slider.value = stepValue;
                    updateInterface(stepValue);
                    
                    // Effet de clic
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
                
                // Effet au survol
                step.addEventListener('mouseenter', function() {
                    if(!this.classList.contains('active')) {
                        this.style.transform = 'scale(1.05)';
                    }
                });
                
                step.addEventListener('mouseleave', function() {
                    if(!this.classList.contains('active')) {
                        this.style.transform = '';
                    }
                });
            });

            // Gestion du bouton OUI/NON
            const yesNoSwitch = document.getElementById('switch-yes-no');
            yesNoSwitch.addEventListener('change', function() {
                if(this.checked) {
                    console.log('Mode OUI activé - Redirection vers la page scientifique');
                    // Simuler un délai avant la redirection
                    setTimeout(() => {
                        window.location.href = 'carte.html'; // Votre page scientifique
                    }, 500);
                } else {
                    console.log('Mode NON activé - Affichage des données supplémentaires');
                    // Ajouter ici le code pour afficher plus d'informations
                    alert('Fonctionnalité "En savoir plus" à implémenter');
                }
            });

            // Animation d'entrée
            document.querySelector('.main-container').style.animation = 'fadeInUp 0.8s ease-out forwards';
            document.querySelector('.main-container').style.opacity = '0';

            // Initialisation
            updateInterface(0);
            
            // Effet de "flicker" aléatoire pour le fond
            setInterval(() => {
                const effect = document.querySelector('.background-effect');
                if(effect && Math.random() > 0.7) {
                    effect.style.opacity = Math.random() * 0.3 + 0.7;
                }
            }, 1000);
        });