document.addEventListener("DOMContentLoaded", function() {
    
    var heatDataCache = []; 
    var nomColonneScore = "delta"; 
    
    var chartRefuge = null; 
    var chartStats = null; 
    
    var geoJsonCommunes = null; 
    var selectedLayer = null; 
    
    ajouterCalqueRefuge('to_hydro_s.geojson', 'eau.png', 400); 
    
    ajouterCalqueRefuge('parcjardin.geojson', 'arbre.png', 300);

    
    window.ouvrirAide = function() { 
        var m = document.getElementById('modalAide');
        if(m) m.style.display = 'block'; 
    }
    
    window.fermerAide = function() { 
        var m = document.getElementById('modalAide');
        if(m) m.style.display = 'none'; 
    }
    
    // Fermeture au clic en dehors
    window.onclick = function(event) { 
        var m = document.getElementById('modalAide');
        if (event.target == m) fermerAide(); 
    }

    
    fetch('ri_icu_ifu_s.geojson').then(r => r.json()).then(data => {
        heatDataCache = data.features;
        var myRenderer = L.canvas({ padding: 0.5 });
        L.geoJSON(data, {
            renderer: myRenderer, interactive: false,
            style: function(f) { return getStyleICU(parseFloat(f.properties[nomColonneScore])); }
        }).addTo(window.layerCanicule);
        chargerCommunes();
    });

    
    function chargerCommunes() {
        fetch('commune.geojson').then(r => r.json()).then(data => {
            geoJsonCommunes = L.geoJSON(data, {
                style: { 
                    color: "rgba(255, 255, 255, 0.5)", 
                    weight: 1.5, 
                    fillColor: "#ffffff", 
                    fillOpacity: 0.01 // Quasi invisible pour permettre le clic/hover
                },
                onEachFeature: function(feature, layer) {
                    // 1. Tooltip (Nom de la commune)
                    var nom = feature.properties.nom_com || feature.properties.nom;
                    layer.bindTooltip(nom, { 
                        permanent: false, 
                        direction: 'center', 
                        className: 'label-commune' 
                    });

                    // 2. Gestion des événements (Hover + Clic)
                    layer.on({
                        
                        mouseover: function(e) {
                            var l = e.target;
                            
                            
                            if (l !== selectedLayer) {
                                l.setStyle({
                                    weight: 3,
                                    color: '#ffffff', 
                                    fillOpacity: 0.2
                                });
                                l.bringToFront(); // Passe devant les autres pour être bien visible
                            }
                        },

                        
                        mouseout: function(e) {
                            var l = e.target;
                            
                            if (l !== selectedLayer) {
                                geoJsonCommunes.resetStyle(l);
                            }
                        },

                   
                        click: function(e) {
                            L.DomEvent.stopPropagation(e);
                            
                            // Reset de l'ancienne sélection
                            if (selectedLayer) geoJsonCommunes.resetStyle(selectedLayer);
                            
                            selectedLayer = layer;
                            
                           
                            layer.setStyle({ weight: 4, color: '#FFD700', fillOpacity: 0.1 });
                            layer.bringToFront();
                            
                            window.map.fitBounds(layer.getBounds(), { padding: [20, 20] });
                            
                            analyserVille(nom, layer);
                        }
                    });
                }
            }).addTo(window.layerCanicule);
            
            
            setTimeout(() => { if(geoJsonCommunes) geoJsonCommunes.bringToFront(); }, 1000);
        });
    }
    
    function ajouterCalqueRefuge(urlData, urlImage, seuilTaille) {
        fetch(urlData)
            .then(response => response.json())
            .then(data => {
                L.geoJSON(data, {
                    
                    style: { opacity: 0, fillOpacity: 0 },
                    
                    // FILTRE 1 : Exclure les fossés (pour l'eau)
                    filter: function(feature) {
                        if (feature.properties && feature.properties.typea === 'FOSSE') return false;
                        return true;
                    },

                    onEachFeature: function(feature, layer) {
                        // FILTRE 2 : TAILLE
                        // On calcule la "bounding box" (le rectangle qui entoure la forme)
                        var bounds = layer.getBounds();
                        var coinSudOuest = bounds.getSouthWest();
                        var coinNordEst = bounds.getNorthEast();
                        
                        // On calcule la distance en mètres
                        var taille = coinSudOuest.distanceTo(coinNordEst);

                        // Si c'est trop petit, on ne met pas d'icône
                        if (taille < seuilTaille) return;

                        // Si c'est assez grand, on cherche le centre pour poser l'icône
                        var center = bounds.getCenter();
                        
                        // Création de l'icône personnalisée
                        var icon = L.divIcon({
                            className: 'icon-refuge', // Classe définie dans style.css
                            html: `<img src="${urlImage}" style="width: 100%; height: 100%; object-fit: contain;">`,
                            iconSize: [28, 28], // Taille du rond blanc
                            iconAnchor: [14, 14] // Point d'ancrage (le centre)
                        });

                        // Ajout du marqueur sur la carte
                        L.marker(center, { icon: icon, interactive: false }).addTo(window.layerCanicule);
                    }
                });
            });
    }

   
    function analyserVille(nomVille, layerVille) {
        var blocCanicule = document.getElementById('contenu-canicule');
        var accueilCanicule = document.getElementById('accueil-canicule');
        
        // On s'assure que les éléments existent
        if(accueilCanicule) accueilCanicule.style.display = 'none';
        if(blocCanicule) blocCanicule.classList.remove('cache');

        blocCanicule.innerHTML = `<div style="text-align:center; margin-top:50px; color:#aaa;">Analyse de ${nomVille}...</div>`;

        setTimeout(() => {
            var bounds = layerVille.getBounds();
            var valeursDelta = []; 

            for (var i = 0; i < heatDataCache.length; i++) {
                var f = heatDataCache[i];
                var coords = trouverCoordonnees(f.geometry.coordinates);
                if (coords) {
                    var latLng = L.latLng(coords[1], coords[0]);
                    if (bounds.contains(latLng)) {
                        var val = parseFloat(f.properties[nomColonneScore]);
                        if (!isNaN(val) && val > -20 && val < 50) valeursDelta.push(val);
                    }
                }
            }

            if (valeursDelta.length === 0) { afficherErreur(nomVille); return; }

            var stats = {
                min: math.min(valeursDelta),
                max: math.max(valeursDelta),
                moyenne: math.mean(valeursDelta),
                mediane: math.median(valeursDelta), 
                stdDev: math.std(valeursDelta)
            };

            var categories = {
                refuge: valeursDelta.filter(v => v < 1).length,
                neutre: valeursDelta.filter(v => v >= 1 && v < 4).length,
                chaud: valeursDelta.filter(v => v >= 4).length
            };

            afficherResultatsComplets(nomVille, stats, categories, valeursDelta.length);
        }, 50);
    }

   
    function afficherResultatsComplets(nom, stats, cats, totalPoints) {
        var blocCanicule = document.getElementById('contenu-canicule');
        var pctRefuge = Math.round((cats.refuge / totalPoints) * 100);
        
        var couleur = "#fdcb6e";
        if (pctRefuge > 50) couleur = "#00b894";
        else if (cats.chaud > cats.refuge) couleur = "#d63031";

        var amplitude = stats.max - stats.min;
        var diagAmplitude = amplitude > 4 ? "Ville Résiliente (Contrastée)" : "Ville Homogène (Risque)";

        blocCanicule.innerHTML = `
            <h2 style="border-bottom: 2px solid ${couleur}; padding-bottom:10px; margin-top:0; color:white;">${nom}</h2>
            
            <div style="background:rgba(255,255,255,0.05); padding:10px; border-radius:8px; text-align:center; margin-bottom:20px;">
                <span style="font-size:2em; font-weight:bold; color:${couleur};">${pctRefuge}%</span>
                <span style="color:#aaa; font-size:0.9em;"> de surface Refuge</span>
            </div>

            <h4 style="color:#ddd; margin:0 0 10px 0; font-size:0.9em; border-bottom:1px solid #444;">1. Répartition du Territoire</h4>
            
            <div style="height: 280px; width:100%; position:relative; margin-bottom:30px;">
                <div id="info-survol" class="info-graph-fixe">
                    <span style="font-size:0.8em; color:#ccc;">Survolez</span><br>
                    <span style="font-size:1.1em; color:#fff; font-weight:bold;">le graph</span>
                </div>
                <canvas id="chartRefuge"></canvas>
            </div>

            <div style="height: 200px; width:100%; position:relative; margin-bottom:10px;">
                <canvas id="chartStats"></canvas>
            </div>

            <div style="text-align:center; font-size:0.85em; font-weight:bold; color:${amplitude > 4 ? '#00b894' : '#e17055'}; margin-bottom:10px;">
                Diagnostic : ${diagAmplitude}
            </div>
            
            <p style="text-align:center; font-size:0.8em; color:#555;">${totalPoints} points analysés</p>
        `;

        if (chartRefuge) chartRefuge.destroy();
        if (chartStats) chartStats.destroy();

        // --- CHART 1 (Doughnut) ---
        var ctxRefuge = document.getElementById('chartRefuge').getContext('2d');
        chartRefuge = new Chart(ctxRefuge, {
            type: 'doughnut',
            data: {
                labels: ['Refuge', 'Neutre', 'Chaud'],
                datasets: [{ 
                    data: [cats.refuge, cats.neutre, cats.chaud], 
                    backgroundColor: ['#00b894', '#fdcb6e', '#d63031'], 
                    borderWidth: 0,
                    hoverOffset: 15 
                }]
            },
            options: { 
                responsive: true, 
                maintainAspectRatio: false, 
                plugins: { 
                    legend: { position: 'left', labels: { color: '#ccc', boxWidth:16 } },
                    tooltip: { enabled: false }
                },
                onHover: function(event, activeElements) {
                    var infoBox = document.getElementById('info-survol');
                    if (activeElements && activeElements.length > 0) {
                        var index = activeElements[0].index;
                        var label = this.data.labels[index];
                        var value = this.data.datasets[0].data[index];
                        var total = this.data.datasets[0].data.reduce((a, b) => a + b, 0);
                        var pct = Math.round((value / total) * 100);
                        var color = this.data.datasets[0].backgroundColor[index];

                        infoBox.innerHTML = `<span style="font-size:0.8em; color:${color};">${label}</span><br><span style="font-size:1.6em; color:#fff; font-weight:bold;">${pct}%</span>`;
                    } else {
                        infoBox.innerHTML = `<span style="font-size:0.8em; color:#ccc;">Survolez</span><br><span style="font-size:1.1em; color:#fff; font-weight:bold;">le graph</span>`;
                    }
                }
            }
        });

        
    }

    function trouverCoordonnees(coords) {
        if (!coords || coords.length === 0) return null;
        if (typeof coords[0] === 'number') return coords;
        if (Array.isArray(coords[0]) && typeof coords[0][0] === 'number') return coords[0];
        return trouverCoordonnees(coords[0]);
    }
    function getStyleICU(val) {
        var c = "#ccc";
        if (val >= 4) c = '#d63031';
        else if (val >= 2) c = '#e17055';
        else if (val >= 0.5) c = '#fdcb6e';
        else c = '#00b894';
        return { fillColor: c, weight: 0, fillOpacity: 0.6, color: 'transparent' };
    }
});